/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pull.PullEvent;
import net.sf.saxon.pull.PullFilter;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;

public class PullNamespaceReducer
extends PullFilter
implements NamespaceResolver {
    private NodeName[] namestack = new NodeName[50];
    NodeName elementJustEnded = null;
    private NamespaceBinding[] allNamespaces = new NamespaceBinding[50];
    private int allNamespacesSize = 0;
    private int[] namespaceCountStack = new int[50];
    private int depth = 0;
    private NamespaceBinding[] localNamespaces;
    private int localNamespacesSize = 0;
    private NodeName nodeName;
    private NamespaceBinding[] declaredNamespaces;
    private AttributeMap attributeMap;
    private final NamespaceBinding[] pendingUndeclarations = null;

    public PullNamespaceReducer(PullProvider base) {
        super(base);
    }

    public PullEvent next() throws XPathException {
        this.currentEvent = super.next();
        switch (this.currentEvent) {
            case START_ELEMENT: {
                this.startElement();
                break;
            }
            case END_ELEMENT: {
                this.endElement();
                break;
            }
            case PROCESSING_INSTRUCTION: 
            case ATTRIBUTE: 
            case NAMESPACE: {
                this.nodeName = super.getNodeName();
                break;
            }
            default: {
                this.nodeName = null;
            }
        }
        return this.currentEvent;
    }

    private void startElement() throws XPathException {
        this.namespaceCountStack[this.depth] = 0;
        if (++this.depth >= this.namespaceCountStack.length) {
            this.namespaceCountStack = Arrays.copyOf(this.namespaceCountStack, this.depth * 2);
            this.namestack = Arrays.copyOf(this.namestack, this.depth * 2);
        }
        this.localNamespaces = super.getNamespaceDeclarations();
        this.localNamespacesSize = 0;
        for (int i = 0; i < this.localNamespaces.length && this.localNamespaces[i] != null; ++i) {
            if (!this.isNeeded(this.localNamespaces[i])) continue;
            this.addGlobalNamespace(this.localNamespaces[i]);
            int n = this.depth - 1;
            this.namespaceCountStack[n] = this.namespaceCountStack[n] + 1;
            this.localNamespaces[this.localNamespacesSize++] = this.localNamespaces[i];
        }
        this.namestack[this.depth - 1] = this.nodeName = this.checkProposedPrefix(super.getNodeName(), 0);
        this.attributeMap = super.getAttributes();
        ArrayList<AttributeInfo> list = new ArrayList<AttributeInfo>(this.attributeMap.size());
        for (AttributeInfo att : this.attributeMap) {
            NodeName newnc;
            NodeName nc = att.getNodeName();
            AttributeInfo att2 = att;
            if (!nc.getNamespaceUri().isEmpty() && nc != (newnc = this.checkProposedPrefix(nc, list.size()))) {
                att2 = new AttributeInfo(newnc, att.getType(), att.getValue(), att.getLocation(), att.getProperties());
            }
            list.add(att2);
        }
        this.attributeMap = SequenceTool.attributeMapFromList(list);
        if (this.localNamespacesSize < this.localNamespaces.length) {
            this.localNamespaces[this.localNamespacesSize] = null;
        }
        this.declaredNamespaces = this.localNamespaces;
        this.namespaceCountStack[this.depth - 1] = this.localNamespacesSize;
    }

    private void addLocalNamespace(NamespaceBinding nc) {
        if (this.localNamespacesSize < this.localNamespaces.length) {
            this.localNamespaces[this.localNamespacesSize++] = nc;
        } else if (this.localNamespacesSize == 0) {
            this.localNamespaces = new NamespaceBinding[10];
        } else {
            this.localNamespaces = Arrays.copyOf(this.localNamespaces, this.localNamespacesSize * 2);
            this.localNamespaces[this.localNamespacesSize++] = nc;
        }
        this.addGlobalNamespace(nc);
    }

    private boolean isNeeded(NamespaceBinding nscode) {
        if (nscode.isXmlNamespace()) {
            return false;
        }
        if (this.pendingUndeclarations != null) {
            for (int p = 0; p < this.pendingUndeclarations.length; ++p) {
                if (!nscode.getPrefix().equals(this.pendingUndeclarations[p].getPrefix())) continue;
                this.pendingUndeclarations[p] = null;
            }
        }
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (this.allNamespaces[i] == nscode) {
                return false;
            }
            if (!this.allNamespaces[i].getPrefix().equals(nscode.getPrefix())) continue;
            return true;
        }
        return !nscode.isDefaultUndeclaration();
    }

    private NodeName checkProposedPrefix(NodeName nameCode, int seq) {
        String oldPrefix = nameCode.getPrefix();
        NamespaceUri uri = nameCode.getNamespaceUri();
        NamespaceBinding nsBinding = new NamespaceBinding(oldPrefix, uri);
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (!oldPrefix.equals(this.allNamespaces[i].getPrefix())) continue;
            if (uri.equals(this.allNamespaces[i].getNamespaceUri())) {
                return nameCode;
            }
            if (i + this.localNamespacesSize >= this.allNamespacesSize) {
                String newPrefix = this.getSubstitutePrefix(oldPrefix, seq);
                FingerprintedQName newNameCode = new FingerprintedQName(newPrefix, uri, nameCode.getLocalPart());
                NamespaceBinding newNSCode = new NamespaceBinding(newPrefix, uri);
                this.addLocalNamespace(newNSCode);
                return newNameCode;
            }
            this.addLocalNamespace(nsBinding);
            return nameCode;
        }
        if (!nsBinding.isDefaultUndeclaration()) {
            this.addLocalNamespace(nsBinding);
        }
        return nameCode;
    }

    private String getSubstitutePrefix(String prefix, int seq) {
        return prefix + '_' + seq;
    }

    private void addGlobalNamespace(NamespaceBinding nscode) {
        if (this.allNamespacesSize + 1 >= this.allNamespaces.length) {
            this.allNamespaces = Arrays.copyOf(this.allNamespaces, this.allNamespacesSize * 2);
        }
        this.allNamespaces[this.allNamespacesSize++] = nscode;
    }

    public AttributeMap getAttributes() {
        return this.attributeMap;
    }

    public NamespaceBinding[] getNamespaceDeclarations() {
        if (this.currentEvent == PullEvent.END_ELEMENT) {
            int nscount = this.namespaceCountStack[this.depth];
            NamespaceBinding[] namespaces = new NamespaceBinding[nscount];
            System.arraycopy(this.allNamespaces, this.allNamespacesSize, namespaces, 0, nscount);
            return namespaces;
        }
        return this.declaredNamespaces;
    }

    public void endElement() throws XPathException {
        if (this.depth-- == 0) {
            throw new IllegalStateException("Attempt to output end tag with no matching start tag");
        }
        this.elementJustEnded = this.namestack[this.depth];
        this.allNamespacesSize -= this.namespaceCountStack[this.depth];
    }

    public NamespaceUri getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.isEmpty() && !useDefault) {
            return NamespaceUri.NULL;
        }
        if ("xml".equals(prefix)) {
            return NamespaceUri.XML;
        }
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (!this.allNamespaces[i].getPrefix().equals(prefix)) continue;
            return this.allNamespaces[i].getNamespaceUri();
        }
        return prefix.isEmpty() ? NamespaceUri.NULL : null;
    }

    public Iterator<String> iteratePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.allNamespacesSize);
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            String prefix = this.allNamespaces[i].getPrefix();
            if (prefixes.contains(prefix)) continue;
            prefixes.add(prefix);
        }
        prefixes.add("xml");
        return prefixes.iterator();
    }
}

