/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj;

import com.saxonica.xqj.Closable;
import com.saxonica.xqj.SaxonXQItem;
import com.saxonica.xqj.SaxonXQPreparedExpression;
import com.saxonica.xqj.SaxonXQSequence;
import com.saxonica.xqj.pull.PullFromIterator;
import com.saxonica.xqj.pull.PullToStax;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultSequence;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.PrependSequenceIterator;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class SaxonXQForwardSequence
extends Closable
implements XQResultSequence {
    private final FocusIterator iterator;
    SaxonXQPreparedExpression expression;
    int position = 0;
    int lastReadPosition = Integer.MIN_VALUE;

    protected SaxonXQForwardSequence(FocusIterator iterator, SaxonXQPreparedExpression expression) {
        this.iterator = iterator;
        this.expression = expression;
        this.setClosableContainer(expression);
    }

    SequenceIterator getIterator() {
        return this.iterator;
    }

    Configuration getConfiguration() {
        return this.expression.getConnection().getConfiguration();
    }

    @Override
    public XQConnection getConnection() throws XQException {
        this.checkNotClosed();
        return this.expression.getConnection();
    }

    @Override
    public String getAtomicValue() throws XQException {
        return this.getCurrentXQItem(true).getAtomicValue();
    }

    @Override
    public boolean getBoolean() throws XQException {
        return this.getCurrentXQItem(true).getBoolean();
    }

    @Override
    public byte getByte() throws XQException {
        return this.getCurrentXQItem(true).getByte();
    }

    @Override
    public double getDouble() throws XQException {
        return this.getCurrentXQItem(true).getDouble();
    }

    @Override
    public float getFloat() throws XQException {
        return this.getCurrentXQItem(true).getFloat();
    }

    @Override
    public int getInt() throws XQException {
        return this.getCurrentXQItem(true).getInt();
    }

    @Override
    public XMLStreamReader getItemAsStream() throws XQException {
        return this.getCurrentXQItem(true).getItemAsStream();
    }

    @Override
    public String getItemAsString(Properties props) throws XQException {
        return this.getCurrentXQItem(true).getItemAsString(props);
    }

    @Override
    public XQItemType getItemType() throws XQException {
        return this.getCurrentXQItem(false).getItemType();
    }

    @Override
    public long getLong() throws XQException {
        return this.getCurrentXQItem(true).getLong();
    }

    @Override
    public Node getNode() throws XQException {
        return this.getCurrentXQItem(true).getNode();
    }

    @Override
    public URI getNodeUri() throws XQException {
        return this.getCurrentXQItem(false).getNodeUri();
    }

    @Override
    public Object getObject() throws XQException {
        return this.getCurrentXQItem(true).getObject();
    }

    @Override
    public short getShort() throws XQException {
        return this.getCurrentXQItem(true).getShort();
    }

    @Override
    public boolean instanceOf(XQItemType type) throws XQException {
        return this.getCurrentXQItem(false).instanceOf(type);
    }

    @Override
    public void writeItem(OutputStream os, Properties props) throws XQException {
        this.getCurrentXQItem(true).writeItem(os, props);
    }

    @Override
    public void writeItem(Writer ow, Properties props) throws XQException {
        this.getCurrentXQItem(true).writeItem(ow, props);
    }

    @Override
    public void writeItemToResult(Result result) throws XQException {
        this.getCurrentXQItem(true).writeItemToResult(result);
    }

    @Override
    public void writeItemToSAX(ContentHandler saxHandler) throws XQException {
        this.getCurrentXQItem(true).writeItemToSAX(saxHandler);
    }

    @Override
    public boolean absolute(int itempos) throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public void afterLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public void beforeFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public int count() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public boolean first() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public XQItem getItem() throws XQException {
        return this.getCurrentXQItem(true);
    }

    @Override
    public int getPosition() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public XMLStreamReader getSequenceAsStream() throws XQException {
        this.checkNotClosed();
        this.checkOnlyReadOnce();
        PullFromIterator provider = new PullFromIterator(this.iterateRemainder());
        provider.setPipelineConfiguration(this.getConfiguration().makePipelineConfiguration());
        return new PullToStax((PullProvider)provider);
    }

    @Override
    public String getSequenceAsString(Properties props) throws XQException {
        this.checkNotClosed();
        StringWriter sw = new StringWriter();
        this.writeSequence(sw, props);
        return sw.toString();
    }

    @Override
    public boolean isAfterLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public boolean isBeforeFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public boolean isFirst() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public boolean isLast() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public boolean isOnItem() throws XQException {
        this.checkNotClosed();
        return this.position > 0;
    }

    @Override
    public boolean isScrollable() throws XQException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean last() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public boolean next() throws XQException {
        this.checkNotClosed();
        if (this.position < 0) {
            return false;
        }
        Item next = this.iterator.next();
        if (next == null) {
            this.position = -1;
            return false;
        }
        ++this.position;
        return true;
    }

    @Override
    public boolean previous() throws XQException {
        throw new XQException("Sequence is forwards-only");
    }

    @Override
    public boolean relative(int itempos) throws XQException {
        this.checkNotClosed();
        throw new XQException("Sequence is forwards-only, cannot move backwards");
    }

    @Override
    public void writeSequence(OutputStream os, Properties props) throws XQException {
        this.checkNotNull(os);
        this.checkNotClosed();
        this.checkOnlyReadOnce();
        if (props == null) {
            props = new Properties();
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.getConfiguration(), (OutputStream)os, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    @Override
    public void writeSequence(Writer ow, Properties props) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(ow);
        this.checkOnlyReadOnce();
        if (props == null) {
            props = new Properties();
        } else {
            SaxonXQItem.validateSerializationProperties(props, this.expression.getConfiguration());
        }
        props = SaxonXQSequence.setDefaultProperties(props);
        PrintWriter pw = ow instanceof PrintWriter ? (PrintWriter)ow : new PrintWriter(ow);
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.getConfiguration(), (Writer)pw, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    private SequenceIterator iterateRemainder() throws XQException {
        if (this.isOnItem()) {
            return new PrependSequenceIterator(this.iterator.current(), (SequenceIterator)this.iterator);
        }
        return this.iterator;
    }

    @Override
    public void writeSequenceToResult(Result result) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(result);
        this.checkOnlyReadOnce();
        Properties props = SaxonXQSequence.setDefaultProperties(null);
        try {
            QueryResult.serializeSequence((SequenceIterator)this.iterateRemainder(), (Configuration)this.getConfiguration(), (Result)result, (Properties)props);
        }
        catch (XPathException e) {
            throw this.newXQException((Exception)((Object)e));
        }
    }

    @Override
    public void writeSequenceToSAX(ContentHandler saxHandler) throws XQException {
        this.checkNotClosed();
        this.checkNotNull(saxHandler);
        this.writeSequenceToResult(new SAXResult(saxHandler));
    }

    private XQItem getCurrentXQItem(boolean onceOnly) throws XQException {
        this.checkNotClosed();
        if (this.position == 0) {
            throw new XQException("The XQSequence is positioned before the first item");
        }
        if (this.position < 0) {
            throw new XQException("The XQSequence is positioned after the last item");
        }
        if (onceOnly) {
            this.checkOnlyReadOnce();
        }
        SaxonXQItem item = new SaxonXQItem(this.iterator.current(), this.expression.getConnection());
        item.setClosableContainer(this);
        return item;
    }

    Item getSaxonItem() {
        return this.iterator.current();
    }

    private void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }

    private void checkOnlyReadOnce() throws XQException {
        if (this.position == this.lastReadPosition) {
            throw new XQException("XQJ does not allow the same item to be read more than once");
        }
        this.lastReadPosition = this.position;
    }

    private XQException newXQException(Exception err) {
        XQException xqe = new XQException(err.getMessage());
        xqe.initCause(err);
        return xqe;
    }
}

